//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_MATERIAL_NETWORK_SCHEMA_H
#define PXR_IMAGING_HD_MATERIAL_NETWORK_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/schemaTypeDefs.h"
#include "pxr/imaging/hd/materialInterfaceSchema.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_MATERIAL_NETWORK_SCHEMA_TOKENS \
    (nodes) \
    (terminals) \
    (interface) \
    (config) \

TF_DECLARE_PUBLIC_TOKENS(HdMaterialNetworkSchemaTokens, HD_API,
    HD_MATERIAL_NETWORK_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class HdMaterialNetworkSchema
///
/// The MaterialNetwork schema is a container schema that defines a material
/// for a specific render context. A network is composed of nodes, terminals,
/// and interface.
///
/// See also the Material schema documentation for ASCII art diagram.
///
class HdMaterialNetworkSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdMaterialNetworkSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// Maps node names to material nodes. Each material node is a container
    /// that is defined by the MaterialNode schema. The topology of the
    /// network is expressed by the connections found on each material node.
    HD_API
    HdMaterialNodeContainerSchema GetNodes() const;

    /// Maps terminal names to material connections. Each connection is a
    /// container defined by the MaterialConnection schema.
    HD_API
    HdMaterialConnectionContainerSchema GetTerminals() const;

    /// Describes the material's interface (public UI). A material's public
    /// interface has user-authored order, grouping, naming, and mappings.
    HD_API
    HdMaterialInterfaceSchema GetInterface() const;

    HD_API
    HdSampledDataSourceContainerSchema GetConfig() const; 

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdContainerDataSourceHandle &nodes,
        const HdContainerDataSourceHandle &terminals,
        const HdContainerDataSourceHandle &interface,
        const HdContainerDataSourceHandle &config
    );

    /// \class HdMaterialNetworkSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetNodes(
            const HdContainerDataSourceHandle &nodes);
        HD_API
        Builder &SetTerminals(
            const HdContainerDataSourceHandle &terminals);
        HD_API
        Builder &SetInterface(
            const HdContainerDataSourceHandle &interface);
        HD_API
        Builder &SetConfig(
            const HdContainerDataSourceHandle &config);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdContainerDataSourceHandle _nodes;
        HdContainerDataSourceHandle _terminals;
        HdContainerDataSourceHandle _interface;
        HdContainerDataSourceHandle _config;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif