import { neverAbortedSignal } from './common/abort';
import { ExecuteWrapper, returnOrThrow } from './common/Executor';
/**
 * A no-op policy, useful for unit tests and stubs.
 */
export class NoopPolicy {
    constructor() {
        this.executor = new ExecuteWrapper();
        this.onSuccess = this.executor.onSuccess;
        this.onFailure = this.executor.onFailure;
    }
    async execute(fn, signal = neverAbortedSignal) {
        return returnOrThrow(await this.executor.invoke(fn, { signal }));
    }
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/302ff6a2e235c95b88e587d4a4b6eeb1b6613297/node_modules/cockatiel/dist/esm/NoopPolicy.js.map