// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { generateUUID } from "./uuidUtils.common.js";
// NOTE: This could be undefined if not used in a secure context
const uuidFunction = typeof globalThis?.crypto?.randomUUID === "function"
    ? globalThis.crypto.randomUUID.bind(globalThis.crypto)
    : generateUUID;
/**
 * Generated Universally Unique Identifier
 *
 * @returns RFC4122 v4 UUID.
 */
export function randomUUID() {
    return uuidFunction();
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/302ff6a2e235c95b88e587d4a4b6eeb1b6613297/node_modules/@typespec/ts-http-runtime/dist/browser/util/uuidUtils-browser.mjs.map